/*
 * Decompiled with CFR 0.152.
 */
package GameState;

import Entity.MenuOption;
import Entity.Mouse;
import Entity.PlayerSave;
import GameState.GameState;
import GameState.GameStateManager;
import Handlers.Content;
import Handlers.Keys;
import Handlers.Options;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;

public class DifficultyState
extends GameState {
    private Font font;
    private int currentChoice = 1;
    private String[] difficulties = new String[]{"Easy", "Normal", "Hard", "Back"};
    private MenuOption mo;
    private MenuOption mo2;
    private Mouse mouse;

    public DifficultyState(GameStateManager gsm) {
        this.gsm = gsm;
        this.font = new Font("Arial", 0, 22);
        PlayerSave.init();
        this.mo = new MenuOption(this.difficulties, 1, gsm.regFont, 200, 250, 200, 0);
        this.mo2 = new MenuOption("Back", gsm.regFont, 400, 350);
        this.mouse = new Mouse();
        if (Options.getOption(5)) {
            this.currentChoice = PlayerSave.getDifficulty();
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void update() {
        this.handleInput();
        this.mo.update(this.mouse);
        this.mo2.update(this.mouse);
        this.mouse.update();
    }

    @Override
    public void draw(Graphics2D g) {
        g.drawImage((Image)Content.MenuBG, 0, 0, null);
        g.setFont(this.font);
        g.setColor(Color.YELLOW);
        g.setStroke(new BasicStroke(4.0f));
        if (PlayerSave.getDifficulty() == 0) {
            g.drawLine(160, 270, 240, 270);
            g.setColor(Color.WHITE);
            if (this.currentChoice == 3) {
                this.gsm.drawCenteredString("EASY: For new comers in the Space Shooting Genre", 800, 300, g);
            }
        }
        if (PlayerSave.getDifficulty() == 1) {
            g.drawLine(340, 270, 460, 270);
            g.setColor(Color.WHITE);
            if (this.currentChoice == 3) {
                this.gsm.drawCenteredString("NORMAL: For the avid gamer who has experince in Space Shooters", 800, 300, g);
            }
        }
        if (PlayerSave.getDifficulty() == 2) {
            g.drawLine(560, 270, 640, 270);
            g.setColor(Color.WHITE);
            if (this.currentChoice == 3) {
                this.gsm.drawCenteredString("HARD: The most Brutal Difficulty, you will not last long", 800, 300, g);
            }
        }
        if (this.currentChoice == 0) {
            this.gsm.drawCenteredString("EASY: For new comers in the Space Shooting Genre", 800, 300, g);
        }
        if (this.currentChoice == 1) {
            this.gsm.drawCenteredString("NORMAL: For the avid gamer who has experince in Space Shooters", 800, 300, g);
        }
        if (this.currentChoice == 2) {
            this.gsm.drawCenteredString("HARD: The most Brutal Difficulty, you will not last long", 800, 300, g);
        }
        g.setFont(this.gsm.regFont);
        if (Options.getOption(5)) {
            this.mo.draw(g);
            this.mo2.draw(g);
            this.mouse.draw(g);
        } else {
            int i = 0;
            while (i < this.difficulties.length) {
                if (i == this.currentChoice) {
                    g.setColor(Color.YELLOW);
                } else {
                    g.setColor(Color.WHITE);
                }
                if (i != 3) {
                    this.gsm.drawCenteredString(this.difficulties[i], 400 * i + 400, 500, g);
                } else {
                    this.gsm.drawCenteredString(this.difficulties[i], 800, 700, g);
                }
                ++i;
            }
        }
    }

    private void select(int currentChoice) {
        if (currentChoice == 0) {
            PlayerSave.setDifficulty(0);
        } else if (currentChoice == 1) {
            PlayerSave.setDifficulty(1);
        } else if (currentChoice == 2) {
            PlayerSave.setDifficulty(2);
        } else if (currentChoice == 3) {
            this.gsm.setState(0);
        }
        if (currentChoice >= 0 && currentChoice < 4) {
            this.currentChoice = currentChoice;
        }
    }

    @Override
    public void handleInput() {
        if (Keys.isKeyPressed(Keys.ESCAPE)) {
            this.gsm.setState(0);
        }
        if (Options.getOption(5)) {
            if (Keys.isMousePressed(Keys.LEFTCLICK)) {
                this.select(this.mo.getChoice());
            }
            if (Keys.isMousePressed(Keys.LEFTCLICK) && this.mo2.getChoice() != -1) {
                this.select(this.mo2.getChoice() + 3);
            }
        } else {
            if (Keys.isKeyPressed(Keys.ENTER)) {
                this.select(this.currentChoice);
            }
            if (Keys.isKeyPressed(Keys.UP)) {
                if (this.currentChoice == 3) {
                    this.currentChoice = 1;
                }
            } else if (Keys.isKeyPressed(Keys.DOWN)) {
                if (this.currentChoice != 3) {
                    this.currentChoice = 3;
                }
            } else if (Keys.isKeyPressed(Keys.LEFT)) {
                if (this.currentChoice == 1) {
                    this.currentChoice = 0;
                } else if (this.currentChoice == 2) {
                    this.currentChoice = 1;
                }
            } else if (Keys.isKeyPressed(Keys.RIGHT)) {
                if (this.currentChoice == 0) {
                    this.currentChoice = 1;
                } else if (this.currentChoice == 1) {
                    this.currentChoice = 2;
                }
            }
        }
    }
}

